PTRACE(1)                 P32 Programmer's Manual                PTRACE(1)

NAME
        ptrace - print network packets

SYNOPSIS
        itrace ifn [filter | off] [wc]
        otrace ifn [filter | off] [wc]

DESCRIPTION
        The ptrace commands are used to create packet input (itrace) and 
        packet output (otrace) threads which print packets transferred over
        the specified interface if they match the specified filter packet.
        
        The filter packet is stored as a text file of the following format:
        
            FF FF FF FF FF FF FF FF FF FF FF FF 08 00  
        
        The above filter will match ALL IP packets transferred over the 
        specified interface, irrespective of their Ethernet source and 
        destination addresses.
        
        Traced packets are printed in the following format:
        
            ifn n time len dir data
            
            ifn  = P32 interface number 
            n    = trace sequence number    
            time = time [in msec since host startup] at which the packet
                   was sent or received.
            len  = the length of the Ethernet packet
            dir  = > for output, < for input
            data = hex dump of X bytes starting with the Ethernet
                   destination address. X equals the number of bytes in the
                   filter packet.
                   
        If no filter is specified, 54 bytes of all IP packets are printed.
        
NOTES
        The filter value FF matches ANY byte. This is a feature, not a bug.
        This convention greatly simplifies the overhead associated with
        packet filtering and results in minimal impact on performance.
        In cases where Broadcast Packets are to be traced, any desired
        wild-card value can be specified in the wc argument.  

HINTS    
        Shell redirection can be used to print trace output to a file or 
        another Window.
        
        Shell background processing (&) can be used to run a trace thread 
        concurrently.
        
        Trace output can be piped to another command for further processing.
        
        If packets arrive faster than they can be processed, the trace
        sequence number will be non-contiguous.
        
SEE ALSO
        shell(1)
